<?php
$page_title = 'Оптимизация: Сокращение инструкций';
require_once __DIR__ . '/includes/optimization-common.php';
require_once __DIR__ . '/includes/header.php';

$widgetId = $_GET['widget_id'] ?? 0;
$sectionName = $_GET['section_name'] ?? '';
$optimizationType = 'shorten';

$widgets = getWidgetsList();
$sections = $widgetId ? getWidgetSections($widgetId) : [];
$settings = $widgetId && $sectionName ? getOptimizationSettings($widgetId, $sectionName, $optimizationType) : null;
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-scissors"></i> Сокращение инструкций</h1>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card bg-dark mb-3">
            <div class="card-header">
                <h5 class="mb-0">Настройки оптимизации</h5>
            </div>
            <div class="card-body">
                <form id="optimization-form">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="widget_id" class="form-label">Виджет</label>
                            <select class="form-select" id="widget_id" name="widget_id" required>
                                <option value="">Выберите виджет</option>
                                <?php foreach ($widgets as $widget): ?>
                                    <option value="<?php echo $widget['id']; ?>" <?php echo $widget['id'] == $widgetId ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($widget['name']); ?> (<?php echo htmlspecialchars($widget['widget_key']); ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="section_name" class="form-label">Раздел</label>
                            <select class="form-select" id="section_name" name="section_name" required <?php echo !$widgetId ? 'disabled' : ''; ?>>
                                <option value="">Выберите раздел</option>
                                <?php foreach ($sections as $section): ?>
                                    <option value="<?php echo htmlspecialchars($section['section_name']); ?>" <?php echo $section['section_name'] == $sectionName ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars(getSectionNameRu($section['section_name'])); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="question" class="form-label">Тестовый вопрос</label>
                        <textarea class="form-control" id="question" name="question" rows="3" placeholder="Например: У меня болит спина" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label for="model" class="form-label">Модель AI</label>
                        <input type="text" class="form-control" id="model" name="model" value="<?php echo htmlspecialchars($settings['model'] ?? 'google/gemini-2.5-flash-lite'); ?>" placeholder="google/gemini-2.5-flash-lite">
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="save_enabled" name="save_enabled" <?php echo ($settings && $settings['is_enabled']) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="save_enabled">
                                Применить эту оптимизацию при запросах
                            </label>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary" id="run-optimization-btn">
                        <i class="bi bi-play-circle"></i> Запустить оптимизацию
                    </button>
                </form>
            </div>
        </div>
        
        <div id="results-container" style="display: none;">
            <div class="card bg-dark mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Результаты оптимизации</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Токенов до</div>
                                <div class="h4 mb-0" id="original-tokens">-</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Токенов после</div>
                                <div class="h4 mb-0" id="optimized-tokens">-</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Символов до</div>
                                <div class="h4 mb-0" id="original-size">-</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="alert alert-info">
                            <strong>Экономия:</strong> <span id="savings-tokens-percent">-</span>% токенов
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Оригинальный промпт</h6>
                            <pre id="original-prompt" class="bg-dark p-3 rounded" style="max-height: 400px; overflow-y: auto; font-size: 11px; white-space: pre-wrap;"></pre>
                        </div>
                        <div class="col-md-6">
                            <h6>Сокращенный промпт</h6>
                            <pre id="shortened-prompt" class="bg-dark p-3 rounded text-success" style="max-height: 400px; overflow-y: auto; font-size: 11px; white-space: pre-wrap;"></pre>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <h6>Ответ AI</h6>
                        <pre id="ai-response" class="bg-dark p-3 rounded" style="max-height: 200px; overflow-y: auto; font-size: 11px;"></pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('widget_id').addEventListener('change', function() {
    const widgetId = this.value;
    if (widgetId) {
        window.location.href = '?widget_id=' + widgetId;
    }
});

document.getElementById('section_name').addEventListener('change', function() {
    const widgetId = document.getElementById('widget_id').value;
    const sectionName = this.value;
    if (widgetId && sectionName) {
        window.location.href = '?widget_id=' + widgetId + '&section_name=' + sectionName;
    }
});

document.getElementById('optimization-form').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const btn = document.getElementById('run-optimization-btn');
    const originalText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Выполняется...';
    
    const formData = {
        widget_id: parseInt(document.getElementById('widget_id').value),
        section_name: document.getElementById('section_name').value,
        question: document.getElementById('question').value,
        optimization_type: 'shorten',
        model: document.getElementById('model').value || 'google/gemini-2.5-flash-lite',
        save_enabled: document.getElementById('save_enabled').checked
    };
    
    try {
        const response = await fetch('/api/optimize-prompt.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(formData)
        });
        
        const data = await response.json();
        
        if (!data.success) {
            throw new Error(data.error || 'Ошибка выполнения оптимизации');
        }
        
        displayResults(data.result);
        
    } catch (error) {
        alert('Ошибка: ' + error.message);
    } finally {
        btn.disabled = false;
        btn.innerHTML = originalText;
    }
});

function displayResults(result) {
    document.getElementById('results-container').style.display = 'block';
    
    document.getElementById('original-tokens').textContent = formatNumber(result.original_tokens);
    document.getElementById('optimized-tokens').textContent = formatNumber(result.optimized_tokens);
    document.getElementById('original-size').textContent = formatNumber(result.original_prompt.length) + ' символов';
    
    const savingsPercent = calculatePercentChange(result.original_tokens, result.optimized_tokens);
    document.getElementById('savings-tokens-percent').textContent = savingsPercent.toFixed(1);
    
    document.getElementById('original-prompt').textContent = result.original_prompt;
    document.getElementById('shortened-prompt').textContent = result.shortened_prompt;
    document.getElementById('ai-response').textContent = result.ai_response || 'Нет ответа';
}

function formatNumber(num) {
    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
}

function calculatePercentChange(original, optimized) {
    if (original === 0) return 0;
    return ((original - optimized) / original) * 100;
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

