<?php
$page_title = 'Оптимизация: Предварительная фильтрация';
require_once __DIR__ . '/includes/optimization-common.php';
require_once __DIR__ . '/includes/header.php';

$widgetId = $_GET['widget_id'] ?? 0;
$sectionName = $_GET['section_name'] ?? '';
$optimizationType = 'prefilter';

$widgets = getWidgetsList();
$sections = $widgetId ? getWidgetSections($widgetId) : [];
$settings = $widgetId && $sectionName ? getOptimizationSettings($widgetId, $sectionName, $optimizationType) : null;

// Получаем статистику категоризации
$stats = null;
if ($widgetId && $sectionName) {
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, WIDGET_DOMAIN . '/api/categorize-items.php?widget_id=' . $widgetId . '&section_name=' . urlencode($sectionName));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200) {
            $stats = json_decode($response, true);
        }
    } catch (Exception $e) {
        // Игнорируем ошибки
    }
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-funnel"></i> Предварительная фильтрация</h1>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card bg-dark mb-3">
            <div class="card-header">
                <h5 class="mb-0">Настройки оптимизации</h5>
            </div>
            <div class="card-body">
                <form id="optimization-form">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="widget_id" class="form-label">Виджет</label>
                            <select class="form-select" id="widget_id" name="widget_id" required>
                                <option value="">Выберите виджет</option>
                                <?php foreach ($widgets as $widget): ?>
                                    <option value="<?php echo $widget['id']; ?>" <?php echo $widget['id'] == $widgetId ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($widget['name']); ?> (<?php echo htmlspecialchars($widget['widget_key']); ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="section_name" class="form-label">Раздел</label>
                            <select class="form-select" id="section_name" name="section_name" required <?php echo !$widgetId ? 'disabled' : ''; ?>>
                                <option value="">Выберите раздел</option>
                                <?php foreach ($sections as $section): ?>
                                    <option value="<?php echo htmlspecialchars($section['section_name']); ?>" <?php echo $section['section_name'] == $sectionName ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars(getSectionNameRu($section['section_name'])); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="model" class="form-label">Модель AI</label>
                        <input type="text" class="form-control" id="model" name="model" value="<?php echo htmlspecialchars($settings['model'] ?? 'google/gemini-2.5-flash-lite'); ?>" placeholder="google/gemini-2.5-flash-lite">
                        <small class="form-text text-muted">Модель для категоризации элементов</small>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="save_enabled" name="save_enabled" <?php echo ($settings && $settings['is_enabled']) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="save_enabled">
                                Применить эту оптимизацию при запросах
                            </label>
                        </div>
                    </div>
                    
                    <?php if ($widgetId && $sectionName): ?>
                        <div class="mb-3">
                            <button type="button" class="btn btn-primary" id="categorize-btn">
                                <i class="bi bi-tags"></i> Создать категории для всех элементов
                            </button>
                            <button type="button" class="btn btn-danger" id="clear-categories-btn" style="display: none;">
                                <i class="bi bi-trash"></i> Удалить все категории
                            </button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
        
        <?php if ($widgetId && $sectionName && $stats): ?>
            <div class="card bg-dark mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Статистика категоризации</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Всего элементов</div>
                                <div class="h4 mb-0" id="total-items"><?php echo formatNumber($stats['total_items'] ?? 0); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Категоризировано</div>
                                <div class="h4 mb-0" id="categorized-items"><?php echo formatNumber($stats['categorized_items'] ?? 0); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Всего категорий</div>
                                <div class="h4 mb-0" id="total-categories"><?php echo formatNumber($stats['total_categories'] ?? 0); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-secondary p-3 rounded">
                                <div class="text-muted small">Прогресс</div>
                                <div class="h4 mb-0" id="progress-percent"><?php echo number_format($stats['progress_percent'] ?? 0, 1); ?>%</div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if ($stats['total_items'] > 0 && $stats['categorized_items'] < $stats['total_items']): ?>
                        <div class="progress mb-3" style="height: 30px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" 
                                 style="width: <?php echo $stats['progress_percent']; ?>%" 
                                 aria-valuenow="<?php echo $stats['progress_percent']; ?>" 
                                 aria-valuemin="0" 
                                 aria-valuemax="100">
                                <?php echo number_format($stats['progress_percent'], 1); ?>%
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <div id="categorization-progress" style="display: none;">
            <div class="card bg-dark mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Прогресс категоризации</h5>
                </div>
                <div class="card-body">
                    <div class="progress mb-3" style="height: 30px;">
                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" 
                             id="progress-bar" 
                             style="width: 0%" 
                             aria-valuenow="0" 
                             aria-valuemin="0" 
                             aria-valuemax="100">
                            0%
                        </div>
                    </div>
                    <div class="text-center">
                        <div id="progress-text">Обработано: 0 из 0 элементов</div>
                        <div id="progress-details" class="text-muted small mt-2"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if ($widgetId && $sectionName): ?>
            <div class="card bg-dark mb-3">
                <div class="card-header">
                    <h5 class="mb-0">Просмотр категорий элементов</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <input type="text" class="form-control" id="search-item" placeholder="Поиск по ID или описанию...">
                    </div>
                    <div id="items-categories-list" class="bg-dark p-3 rounded" style="max-height: 500px; overflow-y: auto;">
                        <div class="text-muted text-center">Выберите виджет и раздел для просмотра категорий</div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
let categorizationInProgress = false;
let categorizationInterval = null;

document.getElementById('widget_id').addEventListener('change', function() {
    const widgetId = this.value;
    if (widgetId) {
        window.location.href = '?widget_id=' + widgetId;
    }
});

document.getElementById('section_name').addEventListener('change', function() {
    const widgetId = document.getElementById('widget_id').value;
    const sectionName = this.value;
    if (widgetId && sectionName) {
        window.location.href = '?widget_id=' + widgetId + '&section_name=' + sectionName;
    }
});

document.getElementById('save_enabled').addEventListener('change', async function() {
    const widgetId = parseInt(document.getElementById('widget_id').value);
    const sectionName = document.getElementById('section_name').value;
    
    if (!widgetId || !sectionName) {
        return;
    }
    
    const isEnabled = this.checked;
    
    try {
        const response = await fetch('/api/optimize-prompt.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                widget_id: widgetId,
                section_name: sectionName,
                optimization_type: 'prefilter',
                model: document.getElementById('model').value || 'google/gemini-2.5-flash-lite',
                save_enabled: isEnabled,
                question: '' // Пустой вопрос для новой логики
            })
        });
        
        const data = await response.json();
        if (!data.success) {
            throw new Error(data.error || 'Ошибка сохранения настроек');
        }
    } catch (error) {
        alert('Ошибка сохранения настроек: ' + error.message);
        this.checked = !isEnabled; // Откатываем изменение
    }
});

document.getElementById('categorize-btn').addEventListener('click', async function() {
    if (categorizationInProgress) {
        return;
    }
    
    const widgetId = parseInt(document.getElementById('widget_id').value);
    const sectionName = document.getElementById('section_name').value;
    const model = document.getElementById('model').value || 'google/gemini-2.5-flash-lite';
    
    if (!widgetId || !sectionName) {
        alert('Выберите виджет и раздел');
        return;
    }
    
    if (!confirm('Начать категоризацию всех элементов? Это может занять некоторое время.')) {
        return;
    }
    
    categorizationInProgress = true;
    this.disabled = true;
    document.getElementById('categorization-progress').style.display = 'block';
    
    let offset = 0;
    const limit = 10; // Обрабатываем по 10 элементов за раз
    
    const processBatch = async () => {
        try {
            const response = await fetch('/api/categorize-items.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    widget_id: widgetId,
                    section_name: sectionName,
                    model: model,
                    offset: offset,
                    limit: limit
                })
            });
            
            const data = await response.json();
            
            if (data.error) {
                throw new Error(data.error);
            }
            
            // Обновляем прогресс
            const progress = data.total > 0 ? Math.round((data.offset / data.total) * 100) : 0;
            document.getElementById('progress-bar').style.width = progress + '%';
            document.getElementById('progress-bar').setAttribute('aria-valuenow', progress);
            document.getElementById('progress-bar').textContent = progress + '%';
            document.getElementById('progress-text').textContent = `Обработано: ${data.offset} из ${data.total} элементов`;
            document.getElementById('progress-details').textContent = `Создано категорий: ${data.total_categories || 0}`;
            
            if (data.completed) {
                // Категоризация завершена
                categorizationInProgress = false;
                this.disabled = false;
                document.getElementById('categorization-progress').style.display = 'none';
                alert('Категоризация завершена!');
                location.reload();
            } else {
                // Продолжаем обработку следующего пакета
                offset += limit;
                setTimeout(processBatch, 500); // Небольшая задержка между пакетами
            }
        } catch (error) {
            categorizationInProgress = false;
            this.disabled = false;
            document.getElementById('categorization-progress').style.display = 'none';
            alert('Ошибка категоризации: ' + error.message);
        }
    };
    
    processBatch();
});

document.getElementById('clear-categories-btn').addEventListener('click', async function() {
    if (!confirm('Удалить все категории для этого раздела? Это действие нельзя отменить.')) {
        return;
    }
    
    const widgetId = parseInt(document.getElementById('widget_id').value);
    const sectionName = document.getElementById('section_name').value;
    
    try {
        const response = await fetch('/api/clear-categories.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                widget_id: widgetId,
                section_name: sectionName
            })
        });
        
        const data = await response.json();
        
        if (data.error) {
            throw new Error(data.error);
        }
        
        alert('Категории удалены');
        location.reload();
    } catch (error) {
        alert('Ошибка удаления категорий: ' + error.message);
    }
});

// Загружаем список элементов с категориями при загрузке страницы
if (document.getElementById('widget_id').value && document.getElementById('section_name').value) {
    loadItemsCategories();
}

function loadItemsCategories() {
    const widgetId = parseInt(document.getElementById('widget_id').value);
    const sectionName = document.getElementById('section_name').value;
    
    if (!widgetId || !sectionName) {
        return;
    }
    
    // Здесь можно добавить AJAX запрос для загрузки элементов с категориями
    // Пока оставляем пустым, можно реализовать позже
}

function formatNumber(num) {
    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
