<?php
/**
 * Общие функции для страниц оптимизаций
 */

if (!function_exists('getDatabase')) {
    require_once __DIR__ . '/../../config.php';
}

/**
 * Получает настройки оптимизации из БД
 */
function getOptimizationSettings($widgetId, $sectionName, $optimizationType) {
    $db = getDatabase();
    
    $stmt = $db->prepare("
        SELECT * FROM widget_optimizations
        WHERE widget_id = ? AND section_name = ? AND optimization_type = ?
    ");
    $stmt->execute([$widgetId, $sectionName, $optimizationType]);
    
    return $stmt->fetch() ?: null;
}

/**
 * Получает список виджетов для выбора
 */
function getWidgetsList() {
    $db = getDatabase();
    
    $stmt = $db->query("
        SELECT id, name, widget_key, active
        FROM widgets
        ORDER BY name
    ");
    
    return $stmt->fetchAll();
}

/**
 * Получает список разделов для виджета
 */
function getWidgetSections($widgetId) {
    $db = getDatabase();
    
    $stmt = $db->prepare("
        SELECT section_name, is_active
        FROM widget_sections
        WHERE widget_id = ? AND is_active = 1
        ORDER BY section_name
    ");
    $stmt->execute([$widgetId]);
    
    return $stmt->fetchAll();
}

/**
 * Получает название раздела на русском
 */
function getSectionNameRu($sectionName) {
    $names = [
        'specialists' => 'Специалисты',
        'services' => 'Услуги',
        'articles' => 'Статьи',
        'specializations' => 'Специализации'
    ];
    
    return $names[$sectionName] ?? $sectionName;
}

/**
 * Получает название типа оптимизации на русском
 */
function getOptimizationTypeName($type) {
    $names = [
        'prefilter' => 'Предварительная фильтрация',
        'compress' => 'Сжатие описаний',
        'minify' => 'Минификация JSON',
        'shorten' => 'Сокращение инструкций',
        'group' => 'Группировка по категориям'
    ];
    
    return $names[$type] ?? $type;
}

/**
 * Форматирует число с разделителями тысяч
 */
function formatNumber($number) {
    return number_format($number, 0, '.', ' ');
}

/**
 * Вычисляет процент изменения
 */
function calculatePercentChange($original, $optimized) {
    if ($original == 0) {
        return 0;
    }
    
    $change = (($original - $optimized) / $original) * 100;
    return round($change, 1);
}

