<?php
require_once __DIR__ . '/../config.php';
$page_title = 'Бэкапы';
require_once __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-archive"></i> Управление бэкапами</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <button id="runBackupBtn" class="btn btn-primary">
            <i class="bi bi-play-circle"></i> Создать бэкап сейчас
        </button>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-info-circle"></i> Информация</h5>
            </div>
            <div class="card-body">
                <p>Автоматические бэкапы создаются каждый день в <strong>3:00 утра</strong>.</p>
                <p>Бэкапы включают:</p>
                <ul>
                    <li>Полный дамп базы данных MySQL</li>
                    <li>Архив всех файлов проекта (кроме vendor/, cache/, backups/)</li>
                </ul>
                <p>Бэкапы автоматически загружаются на FTP сервер и хранятся последние <strong>100 файлов</strong>.</p>
                <div id="backupStatus" class="mt-3"></div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-folder"></i> Локальные бэкапы</h5>
            </div>
            <div class="card-body">
                <div id="localBackups">
                    <div class="text-center text-muted">
                        <i class="bi bi-hourglass-split"></i> Загрузка...
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-file-text"></i> Лог бэкапов</h5>
            </div>
            <div class="card-body">
                <div id="backupLog" style="max-height: 400px; overflow-y: auto; font-family: monospace; font-size: 12px; background: #1a1a1a; padding: 15px; border-radius: 5px;">
                    <div class="text-center text-muted">
                        <i class="bi bi-hourglass-split"></i> Загрузка...
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let backupStatusInterval = null;

async function runBackup() {
    const btn = document.getElementById('runBackupBtn');
    const originalText = btn.innerHTML;
    
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split"></i> Запуск...';
    
    try {
        const response = await fetch('/admin/ajax/backup-run.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            }
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert('Бэкап успешно запущен в фоновом режиме', 'success');
            // Обновляем статус через 2 секунды
            setTimeout(loadBackupStatus, 2000);
            // Запускаем автообновление статуса
            startStatusPolling();
        } else {
            showAlert('Ошибка: ' + (data.error || 'Неизвестная ошибка'), 'danger');
        }
    } catch (error) {
        showAlert('Ошибка при запуске бэкапа: ' + error.message, 'danger');
    } finally {
        btn.disabled = false;
        btn.innerHTML = originalText;
    }
}

async function loadBackupStatus() {
    try {
        const response = await fetch('/admin/ajax/backup-status.php');
        const data = await response.json();
        
        if (data.success) {
            // Обновляем список локальных бэкапов
            const localBackupsDiv = document.getElementById('localBackups');
            if (data.local_backups && data.local_backups.length > 0) {
                let html = '<div class="table-responsive"><table class="table table-sm table-dark">';
                html += '<thead><tr><th>Файл</th><th>Размер</th><th>Создан</th></tr></thead><tbody>';
                data.local_backups.forEach(backup => {
                    html += `<tr>
                        <td><code>${backup.filename}</code></td>
                        <td>${backup.size_human}</td>
                        <td>${backup.created}</td>
                    </tr>`;
                });
                html += '</tbody></table></div>';
                localBackupsDiv.innerHTML = html;
            } else {
                localBackupsDiv.innerHTML = '<div class="text-muted text-center">Нет локальных бэкапов</div>';
            }
            
            // Обновляем лог
            const logDiv = document.getElementById('backupLog');
            if (data.log_content) {
                logDiv.innerHTML = '<pre style="color: #0f0; margin: 0;">' + 
                    escapeHtml(data.log_content) + '</pre>';
                // Прокручиваем вниз
                logDiv.scrollTop = logDiv.scrollHeight;
            } else {
                logDiv.innerHTML = '<div class="text-muted text-center">Лог пуст</div>';
            }
            
            // Обновляем статус
            const statusDiv = document.getElementById('backupStatus');
            if (data.is_running) {
                statusDiv.innerHTML = '<div class="alert alert-info"><i class="bi bi-arrow-repeat"></i> Бэкап выполняется...</div>';
            } else {
                statusDiv.innerHTML = '<div class="alert alert-success"><i class="bi bi-check-circle"></i> Бэкап не выполняется</div>';
            }
        }
    } catch (error) {
        console.error('Ошибка загрузки статуса:', error);
    }
}

function startStatusPolling() {
    // Останавливаем предыдущий интервал если есть
    if (backupStatusInterval) {
        clearInterval(backupStatusInterval);
    }
    
    // Обновляем статус каждые 5 секунд
    backupStatusInterval = setInterval(loadBackupStatus, 5000);
    
    // Останавливаем через 5 минут
    setTimeout(() => {
        if (backupStatusInterval) {
            clearInterval(backupStatusInterval);
            backupStatusInterval = null;
        }
    }, 300000);
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

function showAlert(message, type = 'info') {
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    const container = document.querySelector('.container-fluid');
    container.insertBefore(alertDiv, container.firstChild);
    
    setTimeout(() => {
        alertDiv.remove();
    }, 5000);
}

// Инициализация
document.getElementById('runBackupBtn').addEventListener('click', runBackup);
loadBackupStatus();
// Обновляем статус каждые 30 секунд
setInterval(loadBackupStatus, 30000);
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

