<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $widgetId = $_GET['widget_id'] ?? null;
    $limit = (int)($_GET['limit'] ?? 20);
    
    if (!$widgetId) {
        throw new Exception('Widget ID is required');
    }
    
    // Ограничиваем limit
    $limit = max(1, min($limit, 100));
    
    $db = getDatabase();
    
    // Получаем последние логи
    $stmt = $db->prepare("
        SELECT 
            id,
            question,
            answer,
            response_time_ms,
            error_message,
            created_at,
            CASE 
                WHEN error_message IS NOT NULL AND error_message != '' THEN 'error'
                ELSE 'success'
            END as status
        FROM widget_logs
        WHERE widget_id = ?
        ORDER BY created_at DESC
        LIMIT ?
    ");
    $stmt->execute([$widgetId, $limit]);
    $logs = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'logs' => $logs
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

