<?php
/**
 * AJAX: Парсинг всех URL раздела
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $widgetId = $_POST['widget_id'] ?? null;
    $sectionName = $_POST['section_name'] ?? null;
    
    if (!$widgetId) {
        throw new Exception('Widget ID is required');
    }
    
    $db = getDatabase();
    
    // Получаем раздел
    $stmt = $db->prepare("
        SELECT * FROM widget_sections 
        WHERE widget_id = ? AND section_name = ?
    ");
    $stmt->execute([$widgetId, $sectionName]);
    $section = $stmt->fetch();
    
    if (!$section) {
        throw new Exception('Section not found');
    }
    
    // Подсчитываем количество URL для парсинга
    $stmt = $db->prepare("
        SELECT COUNT(*) as total
        FROM discovered_urls 
        WHERE widget_id = ? 
          AND assigned_section = ?
          AND status IN ('assigned', 'parse_error')
    ");
    $stmt->execute([$widgetId, $sectionName]);
    $result = $stmt->fetch();
    $totalPages = $result['total'];
    
    if ($totalPages == 0) {
        throw new Exception('No URLs assigned to this section');
    }
    
    // Создаем задание парсинга
    $stmt = $db->prepare("
        INSERT INTO parsing_jobs 
        (widget_id, section_name, total_pages, status)
        VALUES (?, ?, ?, 'running')
    ");
    $stmt->execute([$widgetId, $sectionName, $totalPages]);
    
    $jobId = $db->lastInsertId();
    
    // Запускаем парсинг в фоне
    $phpBin = '/usr/bin/php';
    $scriptPath = __DIR__ . '/../../parser/run-parsing-discovered.php';
    $logFile = __DIR__ . '/../../logs/parser.log';
    
    $command = sprintf(
        '%s %s %d %d >> %s 2>&1 &',
        escapeshellcmd($phpBin),
        escapeshellarg($scriptPath),
        $jobId,
        $section['id'],
        escapeshellarg($logFile)
    );
    
    exec($command);
    
    echo json_encode([
        'success' => true,
        'job_id' => $jobId,
        'total_pages' => $totalPages,
        'message' => 'Parsing started successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

