<?php
/**
 * AJAX: Получить дерево URL
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $widgetId = $_GET['widget_id'] ?? null;
    
    if (!$widgetId) {
        throw new Exception('Widget ID is required');
    }
    
    $db = getDatabase();
    
    // Получаем все URL виджета (только канонические и дубли для группировки)
    $stmt = $db->prepare("
        SELECT * FROM discovered_urls 
        WHERE widget_id = ?
        ORDER BY normalized_url, is_canonical DESC, id
    ");
    $stmt->execute([$widgetId]);
    $urls = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'urls' => $urls
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

