<?php
/**
 * AJAX: Массовое назначение раздела всем URL в папке
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $widgetId = $_POST['widget_id'] ?? null;
    $path = $_POST['path'] ?? null;
    $section = $_POST['section'] ?? null;
    
    if (!$widgetId || !$path) {
        throw new Exception('Widget ID and path are required');
    }
    
    if (!in_array($section, ['specialists', 'services', 'articles', 'specializations', 'excluded'])) {
        throw new Exception('Invalid section value');
    }
    
    $db = getDatabase();
    
    // Получаем виджет для проверки
    $stmt = $db->prepare("SELECT id FROM widgets WHERE id = ?");
    $stmt->execute([$widgetId]);
    if (!$stmt->fetch()) {
        throw new Exception('Widget not found');
    }
    
    // Обновляем все URL, чей путь начинается с указанного
    // Используем LIKE для поиска по префиксу пути
    $stmt = $db->prepare("
        UPDATE discovered_urls 
        SET assigned_section = ?,
            status = CASE 
                WHEN status = 'new' THEN 'assigned'
                ELSE status 
            END
        WHERE widget_id = ?
        AND is_canonical = 1
        AND url LIKE ?
    ");
    
    // Добавляем % для LIKE поиска
    $pathPattern = '%' . $path . '%';
    $stmt->execute([$section, $widgetId, $pathPattern]);
    
    $updatedCount = $stmt->rowCount();
    
    if ($updatedCount === 0) {
        throw new Exception('No URLs found in this folder');
    }
    
    echo json_encode([
        'success' => true,
        'updated_count' => $updatedCount,
        'message' => "Successfully assigned section to {$updatedCount} URLs"
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

