<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не разрешен']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$client_id = (int)($data['client_id'] ?? 0);
$username = trim($data['username'] ?? '');
$password = $data['password'] ?? '';
$email = trim($data['email'] ?? '');
$full_name = trim($data['full_name'] ?? '');
$phone = trim($data['phone'] ?? '');
$request_limit = isset($data['request_limit']) ? (int)$data['request_limit'] : 20000;
$is_active = isset($data['is_active']) ? (int)$data['is_active'] : 0;

if (!$client_id || empty($username)) {
    echo json_encode(['success' => false, 'error' => 'Не указаны обязательные поля']);
    exit;
}

if (!empty($password) && strlen($password) < 6) {
    echo json_encode(['success' => false, 'error' => 'Пароль должен быть не менее 6 символов']);
    exit;
}

try {
    $db = getDatabase();
    
    // Проверяем, не существует ли уже такой логин у другого клиента
    $stmt = $db->prepare("SELECT id FROM client_users WHERE username = ? AND id != ?");
    $stmt->execute([$username, $client_id]);
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'error' => 'Клиент с таким логином уже существует']);
        exit;
    }
    
    // Обновляем клиента
    if (!empty($password)) {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $db->prepare("
            UPDATE client_users 
            SET username = ?, password_hash = ?, email = ?, full_name = ?, phone = ?, request_limit = ?, is_active = ?
            WHERE id = ?
        ");
        $stmt->execute([$username, $password_hash, $email ?: null, $full_name ?: null, $phone ?: null, $request_limit, $is_active, $client_id]);
    } else {
        $stmt = $db->prepare("
            UPDATE client_users 
            SET username = ?, email = ?, full_name = ?, phone = ?, request_limit = ?, is_active = ?
            WHERE id = ?
        ");
        $stmt->execute([$username, $email ?: null, $full_name ?: null, $phone ?: null, $request_limit, $is_active, $client_id]);
    }
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    logError("Update client error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Ошибка обновления клиента']);
}

