<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не разрешен']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$client_id = (int)($data['client_id'] ?? 0);
$is_active = isset($data['is_active']) ? (int)$data['is_active'] : 0;

if (!$client_id) {
    echo json_encode(['success' => false, 'error' => 'ID клиента не указан']);
    exit;
}

try {
    $db = getDatabase();
    $stmt = $db->prepare("UPDATE client_users SET is_active = ? WHERE id = ?");
    $stmt->execute([$is_active, $client_id]);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    logError("Toggle client status error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Ошибка изменения статуса']);
}



