<?php
/**
 * AJAX: Статус парсинга
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $jobId = $_GET['job_id'] ?? null;
    
    if (!$jobId) {
        throw new Exception('Job ID is required');
    }
    
    $db = getDatabase();
    
    // Получаем статус задания
    $stmt = $db->prepare("SELECT * FROM parsing_jobs WHERE id = ?");
    $stmt->execute([$jobId]);
    $job = $stmt->fetch();
    
    if (!$job) {
        throw new Exception('Job not found');
    }
    
    // Парсим ошибки
    $errors = [];
    if ($job['errors_json']) {
        $errors = json_decode($job['errors_json'], true) ?? [];
    }
    
    echo json_encode([
        'success' => true,
        'job_id' => $job['id'],
        'status' => $job['status'],
        'section_name' => $job['section_name'],
        'total_pages' => $job['total_pages'],
        'processed_pages' => $job['processed_pages'],
        'started_at' => $job['started_at'],
        'finished_at' => $job['finished_at'],
        'errors' => $errors
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

