<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$client_id = (int)($_GET['id'] ?? 0);

if (!$client_id) {
    echo json_encode(['success' => false, 'error' => 'ID клиента не указан']);
    exit;
}

try {
    $db = getDatabase();
    $stmt = $db->prepare("SELECT id, username, email, full_name, phone, request_limit, is_active FROM client_users WHERE id = ?");
    $stmt->execute([$client_id]);
    $client = $stmt->fetch();
    
    if (!$client) {
        echo json_encode(['success' => false, 'error' => 'Клиент не найден']);
        exit;
    }
    
    // Убираем пароль из результата
    unset($client['password_hash']);
    
    echo json_encode(['success' => true, 'client' => $client]);
} catch (Exception $e) {
    logError("Get client error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Ошибка получения данных клиента']);
}

