<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$field_id = $input['field_id'] ?? 0;

if (!$field_id) {
    echo json_encode(['success' => false, 'error' => 'Field ID не указан']);
    exit;
}

try {
    $db = getDatabase();
    
    // Удаляем поле (CASCADE удалит parsed_fields)
    $stmt = $db->prepare("DELETE FROM section_fields WHERE id = ?");
    $stmt->execute([$field_id]);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

