<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не разрешен']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$client_id = (int)($data['client_id'] ?? 0);

if (!$client_id) {
    echo json_encode(['success' => false, 'error' => 'ID клиента не указан']);
    exit;
}

try {
    $db = getDatabase();
    
    // Отвязываем виджеты от клиента (устанавливаем client_id = NULL)
    $stmt = $db->prepare("UPDATE widgets SET client_id = NULL WHERE client_id = ?");
    $stmt->execute([$client_id]);
    
    // Удаляем клиента
    $stmt = $db->prepare("DELETE FROM client_users WHERE id = ?");
    $stmt->execute([$client_id]);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    logError("Delete client error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Ошибка удаления клиента']);
}



