<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

try {
    $db = getDatabase();
    $section_id = $_GET['section_id'] ?? $_POST['section_id'] ?? null;
    
    if (!$section_id) {
        echo json_encode(['success' => false, 'error' => 'Section ID не указан']);
        exit;
    }
    
    // Получаем информацию о секции
    $stmt = $db->prepare("
        SELECT ws.*, w.id as widget_id
        FROM widget_sections ws
        JOIN widgets w ON ws.widget_id = w.id
        WHERE ws.id = ?
    ");
    $stmt->execute([$section_id]);
    $section = $stmt->fetch();
    
    if (!$section) {
        echo json_encode(['success' => false, 'error' => 'Секция не найдена']);
        exit;
    }
    
    // Находим дубли по полю 'name'
    $stmt = $db->prepare("
        SELECT 
            pf.field_value,
            GROUP_CONCAT(pi.id) as item_ids,
            COUNT(*) as count
        FROM parsed_items pi
        JOIN parsed_fields pf ON pi.id = pf.item_id
        WHERE pi.widget_id = ? 
            AND pi.section_name = ? 
            AND pf.field_name = 'name'
            AND pi.is_duplicate = 0
        GROUP BY pf.field_value
        HAVING count > 1
        ORDER BY count DESC
    ");
    $stmt->execute([$section['widget_id'], $section['section_name']]);
    $groups = $stmt->fetchAll();
    
    $total_deleted = 0;
    
    // Для каждой группы дубликатов удаляем все кроме первого
    foreach ($groups as $group) {
        $itemIds = explode(',', $group['item_ids']);
        
        if (count($itemIds) < 2) {
            continue;
        }
        
        // Первый элемент оставляем, остальные удаляем
        $item_ids_to_delete = array_slice($itemIds, 1);
        
        if (empty($item_ids_to_delete)) {
            continue;
        }
        
        // Удаляем элементы (CASCADE удалит parsed_fields)
        $placeholders = str_repeat('?,', count($item_ids_to_delete) - 1) . '?';
        $stmt = $db->prepare("DELETE FROM parsed_items WHERE id IN ($placeholders)");
        $stmt->execute($item_ids_to_delete);
        
        $total_deleted += $stmt->rowCount();
    }
    
    echo json_encode([
        'success' => true,
        'deleted_count' => $total_deleted,
        'groups_processed' => count($groups)
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
