<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Метод не разрешен']);
    exit;
}

try {
    $backup_script = WIDGET_ROOT . '/daily_backup.sh';
    
    if (!file_exists($backup_script)) {
        throw new Exception('Скрипт бэкапа не найден');
    }
    
    if (!is_executable($backup_script)) {
        throw new Exception('Скрипт бэкапа не исполняемый');
    }
    
    // Запускаем бэкап в фоне
    $log_file = LOG_DIR . '/backup.log';
    $command = escapeshellcmd($backup_script) . ' >> ' . escapeshellarg($log_file) . ' 2>&1 &';
    
    // Запускаем процесс в фоне
    exec($command, $output, $return_code);
    
    if ($return_code !== 0) {
        throw new Exception('Не удалось запустить процесс бэкапа');
    }
    
    // Получаем последние строки лога для информации
    $log_tail = '';
    if (file_exists($log_file)) {
        $log_lines = file($log_file);
        $log_tail = implode('', array_slice($log_lines, -10));
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Бэкап запущен в фоновом режиме',
        'log_tail' => $log_tail
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

